/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 13.6)
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 *
 *  Funkcja makeargv rozbija napis na "sowa" rozdzielone biaymi 
 *  znakami i wypenia przekazan tablic argv[] wskanikami do 
 *  kolejnych sw. Wykonuje wic analogiczne zadanie, co kod rozruchowy 
 *  programu w C przy tworzeniu argumentu argv funkcji main().
 *
 *  Biaymi znakami s te znaki, dla ktrych makrodefinicja isspace() z 
 *  pliku <ctype.h> zwraca warto niezerow. Nie s obsugiwane adne 
 *  znaki ucieczki (\, ' czy ").
 *
 *  Znaki \0 s wstawiane do oryginalnego napisu, aby ograniczy kade 
 *  sowo. Z tego powodu, napis rdowy nie moe by stay. Jeeli 
 *  wywoujcy funkcj makeargv chce zachowa oryginaln warto napisu, 
 *  musi samodzielnie utworzy kopi.
 *
 *  Parametry:
 *     string   -- wskazuje na napis, ktry ma zosta rozdzielony. 
 *     argv     -- tablica wskanikw char *, ktra zostanie wypeniona.
 *     argvsize -- rozmiar tablicy argv (ilo wskanikw, ktre moe 
 *                 pomieci.
 *  Zwracana jest ilo znalezionych sw, czyli ilo wskanikw, ktre 
 *  zostay wpisane do tablicy argv. Odpowiada ona parametrowi argc w 
 *  funkcji main().
 *
 *  Jeeli w napisie rdowym jest wicej sw ni miejsc w tablicy 
 *  argv (co okrela parametr argvsize), ostatni element tablicy argv, 
 *  czyli argv[argvsize-1], bdzie zawiera kocow cz napisu 
 *  rdowego, nie rozbit na pojedyncze sowa. (Na przykad, jeeli 
 *  argvsize bdzie rwne 3, napis "a b c d e" zostanie rozbity na 
 *  elementy "a", "b" i "c d e".) Jeeli jest mniej sw w napisie ni 
 *  miejsc w tablicy, do argv[argc] przypisywany jest wskanik pusty.
 *
 */

#include <ctype.h>

int makeargv(char *string, char *argv[], int argvsize)
{
	char *p = string;
	int  i;
	int argc = 0;

	for(i = 0; i < argvsize; i++) {
		/* pomi pocztkowe biae znaki */
		while(isspace(*p))
			p++;

		if(*p != '\0')
			argv[argc++] = p;
		else {
			argv[argc] = 0;
			break;
		}

		/* przegldanie argumentu */
		while(*p != '\0' && !isspace(*p))
			p++;
		/* zakoczenie sowa */
		if(*p != '\0' && i < argvsize-1)
			*p++ = '\0';
	}

	return argc;
}
